(* Content-type: application/vnd.wolfram.cdf.text *)

(*** Wolfram CDF File ***)
(* http://www.wolfram.com/cdf *)

(* CreatedBy='Mathematica 10.0' *)

(*************************************************************************)
(*                                                                       *)
(*  The Mathematica License under which this file was created prohibits  *)
(*  restricting third parties in receipt of this file from republishing  *)
(*  or redistributing it by any means, including but not limited to      *)
(*  rights management or terms of use, without the express consent of    *)
(*  Wolfram Research, Inc. For additional information concerning CDF     *)
(*  licensing and redistribution see:                                    *)
(*                                                                       *)
(*        www.wolfram.com/cdf/adopting-cdf/licensing-options.html        *)
(*                                                                       *)
(*************************************************************************)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[      1064,         20]
NotebookDataLength[    221640,       3935]
NotebookOptionsPosition[    222136,       3928]
NotebookOutlinePosition[    222564,       3947]
CellTagsIndexPosition[    222521,       3944]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  StyleBox[
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"The", " ", "countour", " ", "in", " ", "the", " ", 
      RowBox[{"(", 
       RowBox[{"z", ",", "\[Rho]"}], ")"}], " ", "plane"}], ",", " ", 
     RowBox[{
     "where", " ", "z", " ", "is", " ", "one", " ", "of", " ", "the", " ", 
      "other", " ", "parameters", " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[Mu]", "1"], ",", " ", 
        SubscriptBox["\[Mu]", "2"], ",", " ", 
        SubscriptBox["\[Sigma]", "1"], ",", " ", 
        RowBox[{"or", " ", 
         SubscriptBox["\[Sigma]", "2"]}]}], ")"}]}], ",", " ", 
     RowBox[{
     "that", " ", "separates", " ", "the", " ", "region", " ", "where", " ", 
      "the", " ", "average", " ", "is", " ", "best", " ", "from", " ", "the", 
      " ", "region", " ", "where", " ", "model", " ", "1", " ", "is", " ", 
      "best"}]}], "*)"}],
   FontWeight->"Plain",
   FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"c1", "[", 
     RowBox[{
     "\[Mu]1_", ",", " ", "\[Mu]2_", ",", " ", "\[Sigma]1_", ",", " ", 
      "\[Sigma]2_"}], "]"}], " ", ":=", " ", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[Mu]1", "2"], "-", 
      RowBox[{"\[Mu]1", " ", "\[Mu]2"}], "+", 
      SuperscriptBox["\[Sigma]1", "2"]}], 
     RowBox[{"\[Sigma]1", " ", "\[Sigma]2"}]]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"The", " ", "countour", " ", "in", " ", "the", " ", 
       RowBox[{"(", 
        RowBox[{"z", ",", "\[Rho]"}], ")"}], " ", "plane"}], ",", " ", 
      RowBox[{
      "where", " ", "z", " ", "is", " ", "one", " ", "of", " ", "the", " ", 
       "other", " ", "parameters", " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Mu]", "1"], ",", " ", 
         SubscriptBox["\[Mu]", "2"], ",", " ", 
         SubscriptBox["\[Sigma]", "1"], ",", " ", 
         RowBox[{"or", " ", 
          SubscriptBox["\[Sigma]", "2"]}]}], ")"}]}], ",", " ", 
      RowBox[{
      "that", " ", "separates", " ", "the", " ", "region", " ", "where", " ", 
       "the", " ", "average", " ", "is", " ", "best", " ", "from", " ", "the",
        " ", "region", " ", "where", " ", "model", " ", "2", " ", "is", " ", 
       "best"}]}], "*)"}],
    FontWeight->"Plain",
    FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c2", "[", 
     RowBox[{
     "\[Mu]1_", ",", " ", "\[Mu]2_", ",", " ", "\[Sigma]1_", ",", " ", 
      "\[Sigma]2_"}], "]"}], " ", ":=", " ", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Mu]1"}], " ", "\[Mu]2"}], "+", 
      SuperscriptBox["\[Mu]2", "2"], "+", 
      SuperscriptBox["\[Sigma]2", "2"]}], 
     RowBox[{"\[Sigma]1", " ", "\[Sigma]2"}]]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"The", " ", "optimal", " ", "weight"}], ",", " ", 
      SuperscriptBox["w", "*"], ",", " ", 
      RowBox[{
       RowBox[{"as", " ", "a", " ", "function", " ", "of", " ", "the", " ", 
        RowBox[{"parameters", ".", " ", "If"}], " ", 
        SuperscriptBox["w", "*"]}], ">", "1"}], ",", " ", 
      RowBox[{"it", " ", "is", " ", "set", " ", "1", " ", 
       RowBox[{"(", 
        RowBox[{"model", " ", "1", " ", "is", " ", "best"}], ")"}]}], ",", 
      " ", 
      RowBox[{
       RowBox[{"and", " ", "if", " ", 
        SuperscriptBox["w", "*"]}], "<", "0"}], ",", " ", 
      RowBox[{"it", " ", "is", " ", "set", " ", "to", " ", "0", " ", 
       RowBox[{"(", 
        RowBox[{"model", " ", "2", " ", "is", " ", "best"}], ")"}]}]}], "*)"}],
    FontWeight->"Plain",
    FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wStarPlot", "[", 
     RowBox[{
     "\[Rho]_", ",", " ", "\[Mu]1_", ",", " ", "\[Mu]2_", ",", " ", 
      "\[Sigma]1_", ",", " ", "\[Sigma]2_"}], "]"}], " ", ":=", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"w", " ", "=", " ", 
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[Mu]1"}], " ", "\[Mu]2"}], "+", 
         SuperscriptBox["\[Mu]2", "2"], "-", 
         RowBox[{"\[Rho]", " ", "\[Sigma]1", " ", "\[Sigma]2"}], "+", 
         SuperscriptBox["\[Sigma]2", "2"]}], 
        RowBox[{
         SuperscriptBox["\[Mu]1", "2"], "-", 
         RowBox[{"2", " ", "\[Mu]1", " ", "\[Mu]2"}], "+", 
         SuperscriptBox["\[Mu]2", "2"], "+", 
         SuperscriptBox["\[Sigma]1", "2"], "-", 
         RowBox[{"2", " ", "\[Rho]", " ", "\[Sigma]1", " ", "\[Sigma]2"}], 
         "+", 
         SuperscriptBox["\[Sigma]2", "2"]}]]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"wStar", " ", "=", " ", 
       RowBox[{"Which", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"w", "\[GreaterEqual]", "0"}], " ", "&&", " ", 
          RowBox[{"w", "\[LessEqual]", "1"}]}], ",", " ", "w", ",", " ", 
         RowBox[{"w", "<", "0"}], ",", " ", "0", ",", " ", 
         RowBox[{"w", ">", "1"}], ",", " ", "1"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "wStar", "]"}]}], "\[IndentingNewLine]", ")"}]}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
      "Create", " ", "a", " ", "dynamic", " ", "plot", " ", "showing", " ", 
       "the", " ", "regions", " ", "in", " ", "the", " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Mu]", "1"], ",", "\[Rho]"}], ")"}], " ", "plane", 
       " ", "corresponding", " ", "to", " ", "the", " ", "different", " ", 
       "cases", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"avg", " ", "best"}], ",", " ", 
         RowBox[{"mod", " ", "1", " ", "best"}], ",", " ", 
         RowBox[{"mod", " ", "2", " ", "best"}]}], ")"}], " ", "that", " ", 
       "allows", " ", "the", " ", "parameters", " ", 
       SubscriptBox["\[Mu]", "2"]}], ",", " ", 
      SubscriptBox["\[Sigma]", "1"], ",", " ", 
      RowBox[{"and", " ", 
       SubscriptBox["\[Sigma]", "2"], " ", "to", " ", "be", " ", 
       "interactively", " ", 
       RowBox[{"manipulated", ".", " ", "Where"}], " ", "the", " ", "average",
        " ", "is", " ", "best"}], ",", " ", 
      RowBox[{
      "the", " ", "color", " ", "is", " ", "scaled", " ", "by", " ", "the", 
       " ", "underlying", " ", "optimal", " ", "weight", " ", "such", " ", 
       "that", " ", "increasingly", " ", "blue", " ", "tones", " ", 
       "indicate", " ", "regions", " ", "where", " ", "the", " ", "average", 
       " ", "is", " ", "dominated", " ", "by", " ", "model", " ", "1"}], ",", 
      " ", 
      RowBox[{
      "and", " ", "increasingly", " ", "red", " ", "tones", " ", "correspond",
        " ", "to", " ", "regions", " ", "where", " ", "the", " ", "average", 
       " ", "is", " ", "dominated", " ", "by", " ", "model", " ", "2"}]}], 
     " ", "*)"}],
    FontWeight->"Plain",
    FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m1", " ", "=", " ", 
     RowBox[{
     "Manipulate", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      StyleBox[
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "Plot", " ", "the", " ", "density", " ", "map", " ", "showing", " ", 
          "regions", " ", "where", " ", "model", " ", "1", " ", "is", " ", 
          "best", " ", "in", " ", "blue"}], ",", " ", 
         RowBox[{
         "regions", " ", "where", " ", "model", " ", "2", " ", "is", " ", 
          "best", " ", "in", " ", "red"}], ",", " ", 
         RowBox[{
         "and", " ", "a", " ", "gradient", " ", "between", " ", "those", " ", 
          "extremes", " ", "where", " ", "the", " ", "color", " ", 
          "corresponds", " ", "to", " ", "the", " ", "value", " ", "of", " ", 
          "the", " ", "optimal", " ", "weight", " ", "for", " ", "the", " ", 
          "average"}], ",", " ", 
         RowBox[{
          SuperscriptBox["w", "*"], ".", " ", "Here"}], ",", " ", 
         RowBox[{
         "wStarPlot", " ", "is", " ", "taken", " ", "as", " ", "a", " ", 
          "function", " ", "of", " ", 
          SubscriptBox["\[Mu]", "1"], " ", "and", " ", "\[Rho]"}], ",", " ", 
         RowBox[{
         "with", " ", "the", " ", "values", " ", "of", " ", "other", " ", 
          "parameters", " ", "set", " ", "by", " ", "the", " ", 
          "interactitve", " ", "sliders"}]}], " ", "*)"}],
       FontWeight->"Plain",
       FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"p1", " ", ":=", " ", 
         RowBox[{"DensityPlot", "[", 
          RowBox[{
           RowBox[{"wStarPlot", "[", 
            RowBox[{
            "\[Rho]", ",", " ", "\[Mu]1", ",", " ", "\[Mu]2", ",", " ", 
             "\[Sigma]1", ",", "\[Sigma]2"}], "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"\[Mu]1", ",", " ", 
             RowBox[{"-", "10"}], ",", " ", "10"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"\[Rho]", ",", " ", 
             RowBox[{"-", "1"}], ",", " ", "1"}], "}"}], ",", " ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"All", ",", " ", "All", ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "0.001"}], ",", " ", "1.001"}], "}"}]}], "}"}]}],
            ",", " ", 
           RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", " ", 
           RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", " ", 
           RowBox[{"PlotPoints", "\[Rule]", 
            RowBox[{"Round", "[", "pp", "]"}]}], ",", " ", 
           RowBox[{"ColorFunction", "\[Rule]", 
            RowBox[{"ColorData", "[", 
             RowBox[{"{", 
              RowBox[{"\"\<TemperatureMap\>\"", ",", "\"\<Reverse\>\""}], 
              "}"}], "]"}]}], ",", " ", 
           RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"BarLegend", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"ColorData", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    "\"\<TemperatureMap\>\"", ",", "\"\<Reverse\>\""}], "}"}],
                    "]"}], ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", " ", "1"}], "}"}]}], "}"}], ",", " ", 
                RowBox[{"LegendLabel", "\[Rule]", 
                 RowBox[{"Placed", "[", 
                  RowBox[{
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<\!\(\*SuperscriptBox[
StyleBox[\"w\",
FontSlant->\"Italic\"], \"*\"]\)\>\"", ",", " ", "26", ",", " ", "Italic"}], 
                    "]"}], ",", "Right"}], "]"}]}], ",", " ", 
                RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"FontSize", "\[Rule]", "16"}], ",", " ", "Black"}],
                   "]"}]}], ",", 
                RowBox[{"LegendMarkerSize", "\[Rule]", "433"}]}], "]"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"1", ",", "0.536"}], "}"}]}], "]"}]}]}], "]"}]}], ";", 
        " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        StyleBox[
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
           "Plot", " ", "the", " ", "exact", " ", "contour", " ", "line", " ",
             "that", " ", "separates", " ", "the", " ", "region", " ", 
            "where", " ", "the", " ", "average", " ", "is", " ", "best", " ", 
            "from", " ", "the", " ", "region", " ", "where", " ", "model", 
            " ", "1", " ", "is", " ", 
            RowBox[{"best", ".", " ", "Here"}]}], ",", " ", 
           RowBox[{
           "c1", " ", "is", " ", "taken", " ", "as", " ", "a", " ", 
            "functiton", " ", "of", " ", 
            SubscriptBox["\[Mu]", "1"]}], ",", " ", 
           RowBox[{
           "with", " ", "the", " ", "values", " ", "of", " ", "other", " ", 
            "parameters", " ", "set", " ", "by", " ", "the", " ", 
            "interactive", " ", "sliders"}]}], " ", "*)"}],
         FontWeight->"Plain",
         FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", 
        RowBox[{"p2", " ", ":=", " ", "\[IndentingNewLine]", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"c1", "[", 
            RowBox[{
            "\[Mu]1", ",", " ", "\[Mu]2", ",", " ", "\[Sigma]1", ",", " ", 
             "\[Sigma]2"}], "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"\[Mu]1", ",", " ", 
             RowBox[{"-", "10"}], ",", " ", "10"}], "}"}], ",", " ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Automatic", ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", " ", "1"}], "}"}]}], "}"}]}], ",", 
           " ", 
           RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", " ", 
           RowBox[{"AxesOrigin", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "10"}], ",", " ", 
              RowBox[{"-", "1"}]}], "}"}]}], ",", " ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Darker", "[", 
               RowBox[{
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.18", ",", " ", "0.31", ",", " ", "0.93"}], "]"}], 
                ",", " ", "0.2"}], "]"}], ",", " ", "Thick"}], "}"}]}], ",", 
           " ", 
           RowBox[{"Filling", "\[Rule]", "Top"}], ",", " ", 
           RowBox[{"PlotRangePadding", "\[Rule]", "None"}]}], "]"}]}], ";", 
        " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        StyleBox[
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
           "Plot", " ", "the", " ", "exact", " ", "contour", " ", "line", " ",
             "that", " ", "separates", " ", "the", " ", "region", " ", 
            "where", " ", "the", " ", "average", " ", "is", " ", "best", " ", 
            "from", " ", "the", " ", "region", " ", "where", " ", "model", 
            " ", "2", " ", "is", " ", 
            RowBox[{"best", ".", " ", "Here"}]}], ",", " ", 
           RowBox[{
           "c2", " ", "is", " ", "taken", " ", "as", " ", "a", " ", 
            "functiton", " ", "of", " ", 
            SubscriptBox["\[Mu]", "1"]}], ",", " ", 
           RowBox[{
           "with", " ", "the", " ", "values", " ", "of", " ", "other", " ", 
            "parameters", " ", "set", " ", "by", " ", "the", " ", 
            "interactive", " ", "sliders"}]}], " ", "*)"}],
         FontWeight->"Plain",
         FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", 
        RowBox[{"p3", " ", ":=", " ", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"c2", "[", 
            RowBox[{
            "\[Mu]1", ",", " ", "\[Mu]2", ",", " ", "\[Sigma]1", ",", " ", 
             "\[Sigma]2"}], "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"\[Mu]1", ",", " ", 
             RowBox[{"-", "10"}], ",", " ", "10"}], "}"}], ",", " ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Darker", "[", 
               RowBox[{
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.82", ",", " ", "0.13", ",", " ", "0.16"}], "]"}], 
                ",", " ", "0.2"}], "]"}], ",", " ", "Thick"}], "}"}]}], ",", 
           " ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Automatic", ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", " ", "1"}], "}"}]}], "}"}]}], ",", 
           " ", 
           RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", " ", 
           RowBox[{"AxesOrigin", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "10"}], ",", " ", 
              RowBox[{"-", "1"}]}], "}"}]}], ",", " ", 
           RowBox[{"Filling", "\[Rule]", "Top"}], ",", "  ", 
           RowBox[{"PlotRangePadding", "\[Rule]", "None"}]}], "]"}]}], ";", 
        " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        StyleBox[
         RowBox[{"(*", 
          RowBox[{
          "Combine", " ", "the", " ", "density", " ", "map", " ", "and", " ", 
           "contour", " ", "line", " ", "plots", " ", "into", " ", "one", " ",
            "figure"}], " ", "*)"}],
         FontWeight->"Plain",
         FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
         RowBox[{"p1", ",", " ", "p2", ",", " ", "p3", ",", " ", 
          RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", " ", 
          RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<\!\(\*SubscriptBox[\(\[Mu]\), \(1\)]\)\>\"", ",", " ", 
             "\"\<\[Rho]\>\""}], "}"}]}], ",", " ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", " ", "26"}], "]"}]}], ",", " ", 
          RowBox[{"FrameTicksStyle", "\[Rule]", "16"}], ",", " ", 
          RowBox[{"ImageSize", "\[Rule]", "600"}], ",", "  ", 
          RowBox[{"PlotRangePadding", "\[Rule]", "None"}]}], "]"}]}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       StyleBox[
        RowBox[{"(*", 
         RowBox[{
         "Define", " ", "the", " ", "controls", " ", "available", " ", "to", 
          " ", "the", " ", "user", " ", "in", " ", "the", " ", "interactive", 
          " ", "plot"}], " ", "*)"}],
        FontWeight->"Plain",
        FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\[Mu]2", ",", " ", "0", ",", " ", 
           "\"\<\!\(\*SubscriptBox[\(\[Mu]\), \(2\)]\)\>\""}], "}"}], ",", 
         " ", 
         RowBox[{"-", "10"}], ",", " ", "10", ",", " ", 
         RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\[Sigma]1", ",", " ", "1", ",", " ", 
           "\"\<                      \!\(\*SubscriptBox[\(\[Sigma]\), \(1\)]\
\)\>\""}], "}"}], ",", " ", "0.001", ",", " ", "20", ",", " ", 
         RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\[Sigma]2", ",", " ", "5", ",", " ", 
           "\"\<\!\(\*SubscriptBox[\(\[Sigma]\), \(2\)]\)\>\""}], "}"}], ",", 
         " ", "0.001", ",", " ", "20", ",", " ", 
         RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"pp", ",", " ", "60", ",", " ", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<                      r \>\"", ",", " ", "Italic"}], 
            "]"}]}], "}"}], ",", " ", "20", ",", " ", "160", ",", " ", 
         RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "}"}], ",", 
       RowBox[{"ControlPlacement", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "Top", ",", " ", "Top", ",", " ", "Top", ",", " ", "Bottom"}], 
         "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", "Large"}], ",", " ", 
       RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"Same", " ", "as", " ", "above", " ", "for", " ", "m1"}], ",", 
      " ", 
      RowBox[{
      "except", " ", "that", " ", "now", " ", "the", " ", "plot", " ", "is", 
       " ", "made", " ", "in", " ", "the", " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "\[Rho]"}], ")"}], " ", 
       "plane"}], ",", " ", 
      RowBox[{"instead", " ", "of", " ", "the", " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Mu]", "1"], ",", "\[Rho]"}], ")"}], " ", 
       RowBox[{"plane", ".", " ", "Coloring"}], " ", "is", " ", "the", " ", 
       "same", " ", "as", " ", "in", " ", "the", " ", "first", " ", 
       "plot"}]}], " ", "*)"}],
    FontWeight->"Plain",
    FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"m2", " ", "=", " ", 
     RowBox[{"Manipulate", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      StyleBox[
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"As", " ", "above", " ", "for", " ", "p1"}], ",", " ", 
         RowBox[{
         "but", " ", "with", " ", "wStarPlot", " ", "taken", " ", "as", " ", 
          "a", " ", "function", " ", "of", " ", 
          SubscriptBox["\[Sigma]", "1"], " ", "and", " ", "\[Rho]"}], ",", 
         " ", 
         RowBox[{
         "with", " ", "the", " ", "values", " ", "of", " ", "other", " ", 
          "parameters", " ", "set", " ", "by", " ", "the", " ", 
          "interactitve", " ", "sliders"}]}], " ", "*)"}],
       FontWeight->"Plain",
       FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"p4", " ", ":=", " ", 
         RowBox[{"DensityPlot", "[", 
          RowBox[{
           RowBox[{"wStarPlot", "[", 
            RowBox[{
            "\[Rho]", ",", " ", "\[Mu]1", ",", " ", "\[Mu]2", ",", " ", 
             "\[Sigma]1", ",", " ", "\[Sigma]2"}], "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"\[Sigma]1", ",", " ", "0", ",", " ", "20"}], "}"}], ",", 
           " ", 
           RowBox[{"{", 
            RowBox[{"\[Rho]", ",", " ", 
             RowBox[{"-", "1"}], ",", " ", "1"}], "}"}], ",", " ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"All", ",", " ", "All", ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "0.001"}], ",", " ", "1.001"}], "}"}]}], "}"}]}],
            ",", 
           RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", " ", 
           RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", " ", 
           RowBox[{"PlotPoints", "\[Rule]", 
            RowBox[{"Round", "[", "pp", "]"}]}], ",", " ", 
           RowBox[{"ColorFunction", "\[Rule]", 
            RowBox[{"ColorData", "[", 
             RowBox[{"{", 
              RowBox[{"\"\<TemperatureMap\>\"", ",", "\"\<Reverse\>\""}], 
              "}"}], "]"}]}], ",", " ", 
           RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"BarLegend", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"ColorData", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    "\"\<TemperatureMap\>\"", ",", "\"\<Reverse\>\""}], "}"}],
                    "]"}], ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", " ", "1"}], "}"}]}], "}"}], ",", " ", 
                RowBox[{"LegendLabel", "\[Rule]", 
                 RowBox[{"Placed", "[", 
                  RowBox[{
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<\!\(\*SuperscriptBox[
StyleBox[\"w\",
FontSlant->\"Italic\"], \"*\"]\)\>\"", ",", " ", "26", ",", " ", "Italic"}], 
                    "]"}], ",", "Right"}], "]"}]}], ",", " ", 
                RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"FontSize", "\[Rule]", "16"}], ",", " ", "Black"}],
                   "]"}]}], ",", 
                RowBox[{"LegendMarkerSize", "\[Rule]", "433"}]}], "]"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"1", ",", "0.536"}], "}"}]}], "]"}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        StyleBox[
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"As", " ", "above", " ", "for", " ", "p2"}], ",", " ", 
           RowBox[{
           "but", " ", "with", " ", "c1", " ", "taken", " ", "as", " ", "a", 
            " ", "functiton", " ", "of", " ", 
            SubscriptBox["\[Sigma]", "1"]}], ",", " ", 
           RowBox[{
           "with", " ", "the", " ", "values", " ", "of", " ", "other", " ", 
            "parameters", " ", "set", " ", "by", " ", "the", " ", 
            "interactive", " ", "sliders"}]}], " ", "*)"}],
         FontWeight->"Plain",
         FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", 
        RowBox[{"p5", " ", ":=", " ", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"c1", "[", 
            RowBox[{
            "\[Mu]1", ",", " ", "\[Mu]2", ",", " ", "\[Sigma]1", ",", " ", 
             "\[Sigma]2"}], "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"\[Sigma]1", ",", " ", "0", ",", " ", "20"}], "}"}], ",", 
           " ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Automatic", ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", " ", "1"}], "}"}]}], "}"}]}], ",", 
           " ", 
           RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", " ", 
           RowBox[{"AxesOrigin", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "10"}], ",", " ", 
              RowBox[{"-", "1"}]}], "}"}]}], ",", " ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Darker", "[", 
               RowBox[{
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.18", ",", " ", "0.31", ",", " ", "0.93"}], "]"}], 
                ",", " ", "0.2"}], "]"}], ",", " ", "Thick"}], "}"}]}], ",", 
           " ", 
           RowBox[{"PlotRangePadding", "\[Rule]", "None"}]}], "]"}]}], ";", 
        " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        StyleBox[
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"As", " ", "above", " ", "for", " ", "p3"}], ",", " ", 
           RowBox[{
           "but", " ", "with", " ", "c2", " ", "taken", " ", "as", " ", "a", 
            " ", "functiton", " ", "of", " ", 
            SubscriptBox["\[Sigma]", "1"]}], ",", " ", 
           RowBox[{
           "with", " ", "the", " ", "values", " ", "of", " ", "other", " ", 
            "parameters", " ", "set", " ", "by", " ", "the", " ", 
            "interactive", " ", "sliders"}]}], " ", "*)"}],
         FontWeight->"Plain",
         FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", 
        RowBox[{"p6", " ", ":=", " ", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"c2", "[", 
            RowBox[{
            "\[Mu]1", ",", " ", "\[Mu]2", ",", " ", "\[Sigma]1", ",", " ", 
             "\[Sigma]2"}], "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"\[Sigma]1", ",", " ", "0", ",", " ", "20"}], "}"}], ",", 
           " ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Darker", "[", 
               RowBox[{
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.82", ",", " ", "0.13", ",", " ", "0.16"}], "]"}], 
                ",", " ", "0.2"}], "]"}], ",", " ", "Thick"}], "}"}]}], ",", 
           " ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Automatic", ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", " ", "1"}], "}"}]}], "}"}]}], ",", 
           " ", 
           RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", " ", 
           RowBox[{"AxesOrigin", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "10"}], ",", " ", 
              RowBox[{"-", "1"}]}], "}"}]}], ",", "  ", 
           RowBox[{"PlotRangePadding", "\[Rule]", "None"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        StyleBox[
         RowBox[{"(*", 
          RowBox[{
          "Combine", " ", "the", " ", "density", " ", "map", " ", "and", " ", 
           "contour", " ", "line", " ", "plots", " ", "into", " ", "one", " ",
            "figure"}], " ", "*)"}],
         FontWeight->"Plain",
         FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
         RowBox[{"p4", ",", " ", "p5", ",", " ", "p6", ",", " ", 
          RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", " ", 
          RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<\!\(\*SubscriptBox[\(\[Sigma]\), \(1\)]\)\>\"", ",", " ", 
             "\"\<\[Rho]\>\""}], "}"}]}], ",", " ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", " ", "26"}], "]"}]}], ",", " ", 
          RowBox[{"FrameTicksStyle", "\[Rule]", "16"}], ",", " ", 
          RowBox[{"ImageSize", "\[Rule]", "600"}], ",", "  ", 
          RowBox[{"PlotRangePadding", "\[Rule]", "None"}]}], "]"}]}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       StyleBox[
        RowBox[{"(*", 
         RowBox[{
         "Define", " ", "the", " ", "controls", " ", "available", " ", "to", 
          " ", "the", " ", "user", " ", "in", " ", "the", " ", "interactive", 
          " ", "plot"}], " ", "*)"}],
        FontWeight->"Plain",
        FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\[Mu]1", ",", " ", "0", ",", " ", 
           "\"\<\!\(\*SubscriptBox[\(\[Mu]\), \(1\)]\)\>\""}], "}"}], ",", 
         " ", 
         RowBox[{"-", "10"}], ",", " ", "10", ",", " ", 
         RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\[Mu]2", ",", " ", "0", ",", " ", 
           "\"\<                      \!\(\*SubscriptBox[\(\[Mu]\), \
\(2\)]\)\>\""}], "}"}], ",", " ", 
         RowBox[{"-", "10"}], ",", " ", "10", ",", " ", 
         RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\[Sigma]2", ",", " ", "5", ",", " ", 
           "\"\<\!\(\*SubscriptBox[\(\[Sigma]\), \(2\)]\)\>\""}], "}"}], ",", 
         " ", "0.001", ",", " ", "20", ",", " ", 
         RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "}"}], ",", 
       "  ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"pp", ",", " ", "60", ",", " ", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<                      r \>\"", ",", " ", "Italic"}], 
            "]"}]}], "}"}], ",", " ", "20", ",", " ", "160", ",", " ", 
         RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "}"}], ",", 
       RowBox[{"ControlPlacement", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "Top", ",", " ", "Top", ",", " ", "Top", ",", " ", "Bottom"}], 
         "}"}]}], ",", " ", 
       RowBox[{"LabelStyle", "\[Rule]", "Large"}], ",", " ", 
       RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
      "Put", " ", "the", " ", "two", " ", "interactive", " ", "plots"}], ",", 
      " ", 
      RowBox[{"m1", " ", "and", " ", "m2"}], ",", " ", 
      RowBox[{"in", " ", "a", " ", "row"}]}], " ", "*)"}],
    FontWeight->"Plain",
    FontColor->GrayLevel[0.5]], "\[IndentingNewLine]", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"m1", ",", " ", "m2"}], "}"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 FontFamily->"Courier New",
 FontSize->14],

Cell[BoxData[
 TemplateBox[{TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`pp$$ = 60, $CellContext`\[Mu]2$$ = 
       0, $CellContext`\[Sigma]1$$ = 1, $CellContext`\[Sigma]2$$ = 5, 
       Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
       Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
       1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
           Hold[$CellContext`\[Mu]2$$], 0, 
           "\!\(\*SubscriptBox[\(\[Mu]\), \(2\)]\)"}, -10, 10}, {{
           Hold[$CellContext`\[Sigma]1$$], 1, 
           "                      \!\(\*SubscriptBox[\(\[Sigma]\), \(1\)]\)"},
           0.001, 20}, {{
           Hold[$CellContext`\[Sigma]2$$], 5, 
           "\!\(\*SubscriptBox[\(\[Sigma]\), \(2\)]\)"}, 0.001, 20}, {{
           Hold[$CellContext`pp$$], 60, 
           Style["                      r ", Italic]}, 20, 160}}, 
       Typeset`size$$ = {600., {241., 247.}}, Typeset`update$$ = 0, 
       Typeset`initDone$$, Typeset`skipInitDone$$ = 
       False, $CellContext`\[Mu]2$501$$ = 0, $CellContext`\[Sigma]1$506$$ = 
       0, $CellContext`\[Sigma]2$507$$ = 0, $CellContext`pp$508$$ = 0}, 
      DynamicBox[
       Manipulate`ManipulateBoxes[
       1, StandardForm, 
        "Variables" :> {$CellContext`pp$$ = 60, $CellContext`\[Mu]2$$ = 
          0, $CellContext`\[Sigma]1$$ = 1, $CellContext`\[Sigma]2$$ = 5}, 
        "ControllerVariables" :> {
          Hold[$CellContext`\[Mu]2$$, $CellContext`\[Mu]2$501$$, 0], 
          Hold[$CellContext`\[Sigma]1$$, $CellContext`\[Sigma]1$506$$, 0], 
          Hold[$CellContext`\[Sigma]2$$, $CellContext`\[Sigma]2$507$$, 0], 
          Hold[$CellContext`pp$$, $CellContext`pp$508$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> ($CellContext`p1 := DensityPlot[
            $CellContext`wStarPlot[$CellContext`\[Rho], $CellContext`\[Mu]1, \
$CellContext`\[Mu]2$$, $CellContext`\[Sigma]1$$, $CellContext`\[Sigma]2$$], \
{$CellContext`\[Mu]1, -10, 10}, {$CellContext`\[Rho], -1, 1}, 
            PlotRange -> {All, All, {-0.001, 1.001}}, AspectRatio -> 1, 
            PlotRangePadding -> None, PlotPoints -> Round[$CellContext`pp$$], 
            ColorFunction -> ColorData[{"TemperatureMap", "Reverse"}], 
            ImageSize -> 600, PlotLegends -> Placed[
              BarLegend[{
                ColorData[{"TemperatureMap", "Reverse"}], {0, 1}}, 
               LegendLabel -> Placed[
                 Style[
                 "\!\(\*SuperscriptBox[\n StyleBox[\"w\",\n\
FontSlant->\"Italic\"], \"*\"]\)", 26, Italic], Right], LabelStyle -> 
               Directive[FontSize -> 16, Black], LegendMarkerSize -> 433], {
              1, 0.536}]]; $CellContext`p2 := Plot[
            $CellContext`c1[$CellContext`\[Mu]1, $CellContext`\[Mu]2$$, \
$CellContext`\[Sigma]1$$, $CellContext`\[Sigma]2$$], {$CellContext`\[Mu]1, \
-10, 10}, PlotRange -> {Automatic, {-1, 1}}, AspectRatio -> 1, 
            AxesOrigin -> {-10, -1}, PlotStyle -> {
              Darker[
               RGBColor[0.18, 0.31, 0.93], 0.2], Thick}, Filling -> Top, 
            PlotRangePadding -> None]; $CellContext`p3 := Plot[
            $CellContext`c2[$CellContext`\[Mu]1, $CellContext`\[Mu]2$$, \
$CellContext`\[Sigma]1$$, $CellContext`\[Sigma]2$$], {$CellContext`\[Mu]1, \
-10, 10}, PlotStyle -> {
              Darker[
               RGBColor[0.82, 0.13, 0.16], 0.2], Thick}, 
            PlotRange -> {Automatic, {-1, 1}}, AspectRatio -> 1, 
            AxesOrigin -> {-10, -1}, Filling -> Top, PlotRangePadding -> 
            None]; Show[$CellContext`p1, $CellContext`p2, $CellContext`p3, 
           AspectRatio -> 1, Frame -> True, 
           FrameLabel -> {"\!\(\*SubscriptBox[\(\[Mu]\), \(1\)]\)", "\[Rho]"},
            LabelStyle -> Directive[Black, 26], FrameTicksStyle -> 16, 
           ImageSize -> 600, PlotRangePadding -> None]), 
        "Specifications" :> {{{$CellContext`\[Mu]2$$, 0, 
            "\!\(\*SubscriptBox[\(\[Mu]\), \(2\)]\)"}, -10, 10, Appearance -> 
           "Open"}, {{$CellContext`\[Sigma]1$$, 1, 
            "                      \!\(\*SubscriptBox[\(\[Sigma]\), \
\(1\)]\)"}, 0.001, 20, Appearance -> 
           "Open"}, {{$CellContext`\[Sigma]2$$, 5, 
            "\!\(\*SubscriptBox[\(\[Sigma]\), \(2\)]\)"}, 0.001, 20, 
           Appearance -> "Open"}, {{$CellContext`pp$$, 60, 
            Style["                      r ", Italic]}, 20, 160, Appearance -> 
           "Open"}}, 
        "Options" :> {
         ControlPlacement -> {Top, Top, Top, Bottom}, LabelStyle -> Large}, 
        "DefaultOptions" :> {}], ImageSizeCache -> {647., {393., 400.}}, 
       SingleEvaluation -> True], Deinitialization :> None, 
      DynamicModuleValues :> {}, 
      Initialization :> ({$CellContext`p1 := DensityPlot[
           $CellContext`wStarPlot[$CellContext`\[Rho], $CellContext`\[Mu]1, 
            FE`\[Mu]2$$144, FE`\[Sigma]1$$144, 
            FE`\[Sigma]2$$144], {$CellContext`\[Mu]1, -10, 
            10}, {$CellContext`\[Rho], -1, 1}, 
           PlotRange -> {All, All, {-0.001, 1.001}}, AspectRatio -> 1, 
           PlotRangePadding -> None, PlotPoints -> 60, ColorFunction -> 
           ColorData[{"TemperatureMap", "Reverse"}], ImageSize -> 600, 
           PlotLegends -> Placed[
             BarLegend[{
               ColorData[{"TemperatureMap", "Reverse"}], {0, 1}}, LegendLabel -> 
              Placed[
                Style[
                "\!\(\*SuperscriptBox[\n StyleBox[\"w\",\nFontSlant->\"Italic\
\"], \"*\"]\)", 26, Italic], Right], LabelStyle -> 
              Directive[FontSize -> 16, Black], LegendMarkerSize -> 433], {
             1, 0.536}]], $CellContext`wStarPlot[
           Pattern[$CellContext`\[Rho], 
            Blank[]], 
           Pattern[$CellContext`\[Mu]1, 
            Blank[]], 
           Pattern[$CellContext`\[Mu]2, 
            Blank[]], 
           Pattern[$CellContext`\[Sigma]1, 
            Blank[]], 
           Pattern[$CellContext`\[Sigma]2, 
            
            Blank[]]] := ($CellContext`w = ((-$CellContext`\[Mu]1) \
$CellContext`\[Mu]2 + $CellContext`\[Mu]2^2 - $CellContext`\[Rho] \
$CellContext`\[Sigma]1 $CellContext`\[Sigma]2 + \
$CellContext`\[Sigma]2^2)/($CellContext`\[Mu]1^2 - 
            2 $CellContext`\[Mu]1 $CellContext`\[Mu]2 + $CellContext`\[Mu]2^2 + \
$CellContext`\[Sigma]1^2 - 
            2 $CellContext`\[Rho] $CellContext`\[Sigma]1 \
$CellContext`\[Sigma]2 + $CellContext`\[Sigma]2^2); $CellContext`wStar = Which[
             
             And[$CellContext`w >= 0, $CellContext`w <= 
              1], $CellContext`w, $CellContext`w < 0, 0, $CellContext`w > 1, 
             1]; Return[$CellContext`wStar]), $CellContext`w = 
         0.17495935122800763`, $CellContext`wStar = 0.17495935122800763`, 
         FE`\[Mu]2$$144 = 0, FE`\[Sigma]1$$144 = 1, FE`\[Sigma]2$$144 = 
         5, $CellContext`p2 := Plot[
           $CellContext`c1[$CellContext`\[Mu]1, FE`\[Mu]2$$144, 
            FE`\[Sigma]1$$144, FE`\[Sigma]2$$144], {$CellContext`\[Mu]1, -10, 
            10}, PlotRange -> {Automatic, {-1, 1}}, AspectRatio -> 1, 
           AxesOrigin -> {-10, -1}, PlotStyle -> {
             Darker[
              RGBColor[0.18, 0.31, 0.93], 0.2], Thick}, Filling -> Top, 
           PlotRangePadding -> None], $CellContext`c1[
           Pattern[$CellContext`\[Mu]1, 
            Blank[]], 
           Pattern[$CellContext`\[Mu]2, 
            Blank[]], 
           Pattern[$CellContext`\[Sigma]1, 
            Blank[]], 
           Pattern[$CellContext`\[Sigma]2, 
            
            Blank[]]] := ($CellContext`\[Mu]1^2 - $CellContext`\[Mu]1 \
$CellContext`\[Mu]2 + $CellContext`\[Sigma]1^2)/($CellContext`\[Sigma]1 \
$CellContext`\[Sigma]2), $CellContext`p3 := Plot[
           $CellContext`c0[$CellContext`\[Mu]1, FE`\[Mu]2$$144, 
            FE`\[Sigma]1$$144, FE`\[Sigma]2$$144], {$CellContext`\[Mu]1, -10, 
            10}, PlotStyle -> {
             Darker[
              RGBColor[0.82, 0.13, 0.16], 0.2], Thick}, 
           PlotRange -> {Automatic, {-1, 1}}, AspectRatio -> 1, 
           AxesOrigin -> {-10, -1}, Filling -> Top, PlotRangePadding -> 
           None], $CellContext`c0[
           Pattern[$CellContext`\[Mu]1, 
            Blank[]], 
           Pattern[$CellContext`\[Mu]2, 
            Blank[]], 
           Pattern[$CellContext`\[Sigma]1, 
            Blank[]], 
           Pattern[$CellContext`\[Sigma]2, 
            
            Blank[]]] := ((-$CellContext`\[Mu]1) $CellContext`\[Mu]2 + \
$CellContext`\[Mu]2^2 + $CellContext`\[Sigma]2^2)/($CellContext`\[Sigma]1 \
$CellContext`\[Sigma]2), $CellContext`c2[
           Pattern[$CellContext`\[Mu]1, 
            Blank[]], 
           Pattern[$CellContext`\[Mu]2, 
            Blank[]], 
           Pattern[$CellContext`\[Sigma]1, 
            Blank[]], 
           Pattern[$CellContext`\[Sigma]2, 
            
            Blank[]]] := ((-$CellContext`\[Mu]1) $CellContext`\[Mu]2 + \
$CellContext`\[Mu]2^2 + $CellContext`\[Sigma]2^2)/($CellContext`\[Sigma]1 \
$CellContext`\[Sigma]2)}; Typeset`initDone$$ = True), 
      SynchronousInitialization -> True, 
      UnsavedVariables :> {Typeset`initDone$$}, 
      UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> True,
      StripOnInput -> False], 
    Manipulate`InterpretManipulate[1]],TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`pp$$ = 60, $CellContext`\[Mu]1$$ = 
       0, $CellContext`\[Mu]2$$ = 0, $CellContext`\[Sigma]2$$ = 5, 
       Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
       Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
       1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
           Hold[$CellContext`\[Mu]1$$], 0, 
           "\!\(\*SubscriptBox[\(\[Mu]\), \(1\)]\)"}, -10, 10}, {{
           Hold[$CellContext`\[Mu]2$$], 0, 
           "                      \!\(\*SubscriptBox[\(\[Mu]\), \(2\)]\)"}, \
-10, 10}, {{
           Hold[$CellContext`\[Sigma]2$$], 5, 
           "\!\(\*SubscriptBox[\(\[Sigma]\), \(2\)]\)"}, 0.001, 20}, {{
           Hold[$CellContext`pp$$], 60, 
           Style["                      r ", Italic]}, 20, 160}}, 
       Typeset`size$$ = {600., {241., 247.}}, Typeset`update$$ = 0, 
       Typeset`initDone$$, Typeset`skipInitDone$$ = 
       False, $CellContext`\[Mu]1$541$$ = 0, $CellContext`\[Mu]2$542$$ = 
       0, $CellContext`\[Sigma]2$543$$ = 0, $CellContext`pp$544$$ = 0}, 
      DynamicBox[
       Manipulate`ManipulateBoxes[
       1, StandardForm, 
        "Variables" :> {$CellContext`pp$$ = 60, $CellContext`\[Mu]1$$ = 
          0, $CellContext`\[Mu]2$$ = 0, $CellContext`\[Sigma]2$$ = 5}, 
        "ControllerVariables" :> {
          Hold[$CellContext`\[Mu]1$$, $CellContext`\[Mu]1$541$$, 0], 
          Hold[$CellContext`\[Mu]2$$, $CellContext`\[Mu]2$542$$, 0], 
          Hold[$CellContext`\[Sigma]2$$, $CellContext`\[Sigma]2$543$$, 0], 
          Hold[$CellContext`pp$$, $CellContext`pp$544$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> ($CellContext`p4 := DensityPlot[
            $CellContext`wStarPlot[$CellContext`\[Rho], \
$CellContext`\[Mu]1$$, $CellContext`\[Mu]2$$, $CellContext`\[Sigma]1, \
$CellContext`\[Sigma]2$$], {$CellContext`\[Sigma]1, 0, 
             20}, {$CellContext`\[Rho], -1, 1}, 
            PlotRange -> {All, All, {-0.001, 1.001}}, AspectRatio -> 1, 
            PlotRangePadding -> None, PlotPoints -> Round[$CellContext`pp$$], 
            ColorFunction -> ColorData[{"TemperatureMap", "Reverse"}], 
            ImageSize -> 600, PlotLegends -> Placed[
              BarLegend[{
                ColorData[{"TemperatureMap", "Reverse"}], {0, 1}}, 
               LegendLabel -> Placed[
                 Style[
                 "\!\(\*SuperscriptBox[\n StyleBox[\"w\",\n\
FontSlant->\"Italic\"], \"*\"]\)", 26, Italic], Right], LabelStyle -> 
               Directive[FontSize -> 16, Black], LegendMarkerSize -> 433], {
              1, 0.536}]]; $CellContext`p5 := Plot[
            $CellContext`c1[$CellContext`\[Mu]1$$, $CellContext`\[Mu]2$$, \
$CellContext`\[Sigma]1, $CellContext`\[Sigma]2$$], {$CellContext`\[Sigma]1, 0,
              20}, PlotRange -> {Automatic, {-1, 1}}, AspectRatio -> 1, 
            AxesOrigin -> {-10, -1}, PlotStyle -> {
              Darker[
               RGBColor[0.18, 0.31, 0.93], 0.2], Thick}, PlotRangePadding -> 
            None]; $CellContext`p6 := Plot[
            $CellContext`c2[$CellContext`\[Mu]1$$, $CellContext`\[Mu]2$$, \
$CellContext`\[Sigma]1, $CellContext`\[Sigma]2$$], {$CellContext`\[Sigma]1, 0,
              20}, PlotStyle -> {
              Darker[
               RGBColor[0.82, 0.13, 0.16], 0.2], Thick}, 
            PlotRange -> {Automatic, {-1, 1}}, AspectRatio -> 1, 
            AxesOrigin -> {-10, -1}, PlotRangePadding -> None]; 
         Show[$CellContext`p4, $CellContext`p5, $CellContext`p6, AspectRatio -> 
           1, Frame -> True, 
           FrameLabel -> {
            "\!\(\*SubscriptBox[\(\[Sigma]\), \(1\)]\)", "\[Rho]"}, 
           LabelStyle -> Directive[Black, 26], FrameTicksStyle -> 16, 
           ImageSize -> 600, PlotRangePadding -> None]), 
        "Specifications" :> {{{$CellContext`\[Mu]1$$, 0, 
            "\!\(\*SubscriptBox[\(\[Mu]\), \(1\)]\)"}, -10, 10, Appearance -> 
           "Open"}, {{$CellContext`\[Mu]2$$, 0, 
            "                      \!\(\*SubscriptBox[\(\[Mu]\), \(2\)]\)"}, \
-10, 10, Appearance -> 
           "Open"}, {{$CellContext`\[Sigma]2$$, 5, 
            "\!\(\*SubscriptBox[\(\[Sigma]\), \(2\)]\)"}, 0.001, 20, 
           Appearance -> "Open"}, {{$CellContext`pp$$, 60, 
            Style["                      r ", Italic]}, 20, 160, Appearance -> 
           "Open"}}, 
        "Options" :> {
         ControlPlacement -> {Top, Top, Top, Bottom}, LabelStyle -> Large}, 
        "DefaultOptions" :> {}], ImageSizeCache -> {647., {393., 400.}}, 
       SingleEvaluation -> True], Deinitialization :> None, 
      DynamicModuleValues :> {}, 
      Initialization :> ({$CellContext`p4 = Legended[
           Graphics[
            GraphicsComplex[CompressedData["
1:eJxl3X2sfPlB1/FD7diWoe3s0KHTnZ0yfV7Y0lLZGCTVO4SUpIQQ0hitNoJK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             "], {{{
                EdgeForm[], 
                GrayLevel[0.8], 
                GraphicsGroup[{
                  Polygon[CompressedData["
1:eJxE3Xfc1nP7x/HzO849KpGItChSMkMokZAtQmVFSkI22ZkhZGcle5S9s8ne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                   "]]}]}, {}, {}, {}, {}}}, VertexColors -> CompressedData["
1:eJx0m/k7VO8fh0kltCciSaFoI0JJXpIUSYUWSSmKaFeiRSVJUpK9RQlFpFQo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              "]], {
            DisplayFunction -> Identity, AspectRatio -> 1, DisplayFunction :> 
             Identity, Frame -> True, 
             FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
             GridLinesStyle -> Directive[
               GrayLevel[0.5, 0.4]], ImageSize -> 600, 
             Method -> {
              "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
               Automatic, "ScalingFunctions" -> None}, 
             PlotRange -> {All, All}, PlotRangeClipping -> True, 
             PlotRangePadding -> {{None, None}, {None, None}}, 
             Ticks -> {Automatic, Automatic}}], 
           Placed[
            BarLegend[{
              ColorDataFunction[
              "TemperatureMap", "Gradients", {1, 0}, Blend[{{1., 
                  RGBColor[0.178927, 0.305394, 0.933501]}, {
                 0.9166666666666666, 
                  RGBColor[0.308746, 0.441842, 0.940894]}, {
                 0.8333333333333334, 
                  RGBColor[0.453318, 0.567063, 0.950106]}, {0.75, 
                  RGBColor[0.642359, 0.720535, 0.964988]}, {
                 0.6666666666666667, 
                  RGBColor[0.819984, 0.859297, 0.982692]}, {
                 0.5833333333333334, 
                  RGBColor[0.935699, 0.951565, 0.993729]}, {0.5, 
                  RGBColor[0.984192, 0.987731, 0.911643]}, {
                 0.41666666666666674`, 
                  RGBColor[0.995282, 0.992317, 0.727853]}, {
                 0.33333333333333337`, 
                  RGBColor[0.992503, 0.986373, 0.425376]}, {0.25, 
                  RGBColor[0.955963, 0.863115, 0.283425]}, {
                 0.16666666666666674`, 
                  RGBColor[0.904227, 0.657999, 0.241797]}, {
                 0.08333333333333337, 
                  RGBColor[0.858405, 0.449932, 0.203562]}, {0., 
                  RGBColor[0.817319, 0.134127, 0.164218]}}, #]& ], {0, 1}}, 
             LabelStyle -> Directive[FontSize -> 16, 
               GrayLevel[0]], LegendLabel -> Placed[
               Style[
               "\!\(\*SuperscriptBox[\n StyleBox[\"w\",\n\
FontSlant->\"Italic\"], \"*\"]\)", 26, Italic], Right], LegendLayout -> 
             "Column", LegendMarkerSize -> 433, Charting`TickAnnotations -> 
             None, Charting`TickSide -> Right, ColorFunctionScaling -> 
             True], {1, 0.536}, Identity]], $CellContext`wStarPlot[
           Pattern[$CellContext`\[Rho], 
            Blank[]], 
           Pattern[$CellContext`\[Mu]1, 
            Blank[]], 
           Pattern[$CellContext`\[Mu]2, 
            Blank[]], 
           Pattern[$CellContext`\[Sigma]1, 
            Blank[]], 
           Pattern[$CellContext`\[Sigma]2, 
            
            Blank[]]] := ($CellContext`w = ((-$CellContext`\[Mu]1) \
$CellContext`\[Mu]2 + $CellContext`\[Mu]2^2 - $CellContext`\[Rho] \
$CellContext`\[Sigma]1 $CellContext`\[Sigma]2 + \
$CellContext`\[Sigma]2^2)/($CellContext`\[Mu]1^2 - 
            2 $CellContext`\[Mu]1 $CellContext`\[Mu]2 + $CellContext`\[Mu]2^2 + \
$CellContext`\[Sigma]1^2 - 
            2 $CellContext`\[Rho] $CellContext`\[Sigma]1 \
$CellContext`\[Sigma]2 + $CellContext`\[Sigma]2^2); $CellContext`wStar = Which[
             
             And[$CellContext`w >= 0, $CellContext`w <= 
              1], $CellContext`w, $CellContext`w < 0, 0, $CellContext`w > 1, 
             1]; Return[$CellContext`wStar]), $CellContext`w = 
         0.17495935122800763`, $CellContext`wStar = 
         0.17495935122800763`, $CellContext`p5 = Graphics[{{{}, {}, {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[1.6], 
               RGBColor[0.144, 0.248, 0.744], 
               Thickness[Large]], 
              Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAnX5iBjFkmz5LZejRwOl1Pp5a7DpX
IHk/5a5WYt8ZVD/ZTYpyICCJPxQL1Y6zGWQ/d0dZDgUgmT8rORSlnRl0P0bE
QFz3H6k/N9AzsJIZhD+tgjSD8B+5P76bwzWNGZQ/4WGuFu0fyT+BgYt4ihmk
P3tRa2DrH9k/Y3TvGYkZtD8J+ZvJbC7qPweUSaHw8cQ/ccJ/jOxy8z+20DJH
Rx7PPy6kk9G0rvk/WIPc2sOL1D/lTmgc3zgAQG+xcy2Y9Nk/lxqGHaFgA0Dx
kNbIAQHfPzlyuK8DzAZAx8HGv8884j/D15tQbycKQGl5SQ1Z7OQ/MYz+PhhJ
DUDACTL/rG3nP0fmOt8wVxBApKPE/hol6j/nLbZF9OwRQD4WvaJTruw/e/yJ
M7x6E0Arx9y4xirvPwAAAAAAABRAAAAAAAAA8D+Lx5GV
               "]]}}}, {
           DisplayFunction -> Identity, AspectRatio -> 1, 
            Axes -> {True, True}, AxesLabel -> {None, None}, 
            AxesOrigin -> {-10., -1.}, DisplayFunction :> Identity, 
            Frame -> {{False, False}, {False, False}}, 
            FrameLabel -> {{None, None}, {None, None}}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            GridLines -> {None, None}, GridLinesStyle -> Directive[
              GrayLevel[0.5, 0.4]], 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None},
             PlotRange -> {{-10., 19.999999591836733`}, {-1, 1}}, 
            PlotRangeClipping -> True, 
            PlotRangePadding -> {{None, None}, {None, None}}, 
            Ticks -> {Automatic, Automatic}}], $CellContext`c1[
           Pattern[$CellContext`\[Mu]1, 
            Blank[]], 
           Pattern[$CellContext`\[Mu]2, 
            Blank[]], 
           Pattern[$CellContext`\[Sigma]1, 
            Blank[]], 
           Pattern[$CellContext`\[Sigma]2, 
            
            Blank[]]] := ($CellContext`\[Mu]1^2 - $CellContext`\[Mu]1 \
$CellContext`\[Mu]2 + $CellContext`\[Sigma]1^2)/($CellContext`\[Sigma]1 \
$CellContext`\[Sigma]2), $CellContext`p6 = Graphics[{{{}, {}, {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[1.6], 
               RGBColor[0.6559999999999999, 0.10400000000000001`, 0.128], 
               Thickness[Large]], 
              Line[CompressedData["
1:eJwdjntQE3QcwKewm8CKN/F+Pyfv302kyO+Xx4W81BsRIZUtHkMMiKanxyFF
hAgGiFzsSDh0IMehg9MiRBOWEI+N0Q82QFFMEUSIcIAoArKsz93nPv9+HL7I
4qVsZzAY773xvzLyH4x3s0yQ8T9qYBk+PfwhxxQLG8c8ngctAlPBDNe7ZYbi
4zm8dJcF2BiSfHku2xzn+voNe7znYSa+xcLW1hJ73biBbvlPIfh0Zka/xAq9
Ovg9PLtZ+HHruk7oIRscK3oRZyKbgUTr7uj7K7ZonLdsGSKZBrZ054JjnD2W
ZnNNu0SPIYUrXk3wdMBiPlPOFU/B8bwTPPtVBwzdigh5OPwICucrlUNDjmjg
5OxzUesRRHP0m9g/OSFL0CgJiH0IpZJd0mi+M4636gcHCv4CWWz95tFAFzTR
PfIq1e0BSBVZP3hquWKLYe26sfEkXEvPx8FJVzzA74m0eH0PbKNgd+Yvbtjc
YN0k0UxAqOaTgrpcdyyz4rFXHCcgeaxr+XqcBxb2ijbWQ+7Cnvzv2vj2HPwz
1bKa9c0dOJe1dJM9y0Flw8l2B9k4TH176Uld505Mjk2vijAch79TOpJvF3mi
/tSkfXPmGKgzjFgKvhd2hdTv9+8fhZYI+WaqlzfGqLhXgrij8CTNd5fWqjc2
vXPf/uQVFVhenqgsUvigQHuCd8tOBQWffy1WRPni1btZ7S/FSni5aVEa1eGL
OQWCUYGjEtxviqplzn5Yer4kIaN5BLhJf+w3LPbDNoOZZ60wAtIaU/PBVT/M
FLyr4g4Pg7vUtGRfoj9WB0XqtGYOQwxzwWak0x9F4oB5J6NhUN+b7h7gEBxo
t/LcuEohq6bUuLic4MhA/I6tRAqD25yfRVYQdDmSvVh4kAJHcEPGriTYbWVk
/nYChWm/2fyzVQQ1a3Vcu48ofNyHalEtwTb/ZVHYAQohyyuDjZcJhn7aPHc+
jILZ3oOnevoI+rQVheV6URBK1PxTAwQrOnpPsD0pUKOi9/fKCf56LHaxhkPh
zOTPz+VDBO+UG9R2ulFgCN9KUo4SzNgiLKYjhflaKUw9Juh+TEdTa0YhXCve
qmGGoJCph/6mFBrS/nmRMkuw+PUHv/caUzhELFvm5t/8uHC+VxtQUPULrZeW
CPbU39YJ16Pg5627dm2FoG71b5GTOhTKKi8oj64SXKw4LBfuoBDxmaJkbY1g
VUz1mYtMCo3dSak31gleyFuX7damoO2xHpy7SXC8XB5Bt1Pgl5212bNF0LZv
g5W2jULniusrjYZgwFc5TAaDwr86RbWZ
               "]]}}}, {
           DisplayFunction -> Identity, AspectRatio -> 1, 
            Axes -> {True, True}, AxesLabel -> {None, None}, 
            AxesOrigin -> {-10., -1.}, DisplayFunction :> Identity, 
            Frame -> {{False, False}, {False, False}}, 
            FrameLabel -> {{None, None}, {None, None}}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            GridLines -> {None, None}, GridLinesStyle -> Directive[
              GrayLevel[0.5, 0.4]], 
            Method -> {
             "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None},
             PlotRange -> {{-10., 19.999999591836733`}, {-1, 1}}, 
            PlotRangeClipping -> True, 
            PlotRangePadding -> {{None, None}, {None, None}}, 
            Ticks -> {Automatic, Automatic}}], $CellContext`c2[
           Pattern[$CellContext`\[Mu]1, 
            Blank[]], 
           Pattern[$CellContext`\[Mu]2, 
            Blank[]], 
           Pattern[$CellContext`\[Sigma]1, 
            Blank[]], 
           Pattern[$CellContext`\[Sigma]2, 
            
            Blank[]]] := ((-$CellContext`\[Mu]1) $CellContext`\[Mu]2 + \
$CellContext`\[Mu]2^2 + $CellContext`\[Sigma]2^2)/($CellContext`\[Sigma]1 \
$CellContext`\[Sigma]2)}; Typeset`initDone$$ = True), 
      SynchronousInitialization -> True, 
      UnsavedVariables :> {Typeset`initDone$$}, 
      UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> True,
      StripOnInput -> False], 
    Manipulate`InterpretManipulate[1]]},
  "RowDefault"]], "Output"]
}, Open  ]]
},
WindowSize->{1920, 1056},
Visible->True,
ScrollingOptions->{"VerticalScrollRange"->Fit},
ShowCellBracket->Automatic,
CellContext->Notebook,
TrackCellChangeTimes->False,
FrontEndVersion->"10.0 for Linux x86 (64-bit) (June 27, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[1486, 35, 32423, 741, 1835, "Input"],
Cell[33912, 778, 188208, 3147, 810, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

(* NotebookSignature NuphHSgwRgWRPA1gMSaikiUU *)
